;------------------------------------------------------------------------
; Panasonic 3DO
; FourDO v1.0.2.0 alpha
; by djvj
; 1.1
;
; Notes:
; Download xpath from http://www.autohotkey.net/~Titan/dl/xpath.zip and extract the xpath.ahk into your Hyperspin directory
; xpath is needed because AutoHotKey does not natively support reading/writing of XML files
; This emu only supports iso images
; If your bios file is called fz10_rom.bin, rename it to fz10.rom, it should be placed in the same dir as the emu exe.
; On first launch, FourDO will ask you to point it to the fz10.rom. After you do that, exit the emu and select a game in HS and it should work.
;------------------------------------------------------------------------

#Include xpath.ahk

Gui +AlwaysOnTop -Caption +ToolWindow 
Gui, color, 0
Gui Show, x0 y0 h%A_ScreenHeight% w%A_ScreenWidth%

; Update settings file via script because the emu doesn't support CLI loading of games
settingsPath = %emuPath%FourDO.settings
newromPath = %romPath%%romName%%romExtension%
xpath_load(emuXML, settingsPath ) ; need to read the existing xml otherwise xpath deletes all existing nodes
xpath(emuXML, "/Settings/GameRomFile/text()", newromPath) ; update node with the rom
xpath_save(emuXML, settingsPath) ; write new XML

Run, %executable%, %emuPath%
WinWaitActive, 4DO
Sleep, 200 ; necessary otherwise we send F4 too fast
Send, {F4} ; fullscreen
Process, WaitClose, %executable%

ExitApp

CloseProcess:
	WinClose, 4DO
return